// Exp-9 : Application of Correlation to detect binary sequence at receiver.

// Objective : To transmite a Binary Signal "0" and "1", we used sin(n*pi/8) and sin(n*pi/4) respectively. while transmition noise has been added with these signals. this information will be available to both receiver and transmitter. by finding correlation value between received signal with noise and the two corresponding signals used to represent binary signal "0" or "1", at the receiver side we can detect whether tranmitted signal is binary "0" or "1" 

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7


clc;
clear;
xdel(winsid());
N=30;                       // Length of the signal
n=0:N-1;
pi=3.14;
x0=sin(n*pi/8);             // For '0' transmission
x1=sin(n*pi/4);             // For '1' transmission

scf();
subplot(2,1,1);
bar(n,x0,0.1,'red');
title('Sin(n*pi/8) to Represent Binary 0','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,1,2);
bar(n,x1,0.1,'yellow');
title('Sin(n*pi/4) to Represent Binary 1','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

w=rand(1,N);  // Noise Signal
y0=x0+w;      // Original Signal + Noise Signal
y1=x1+w;      // Original Signal + Noise Signal

// If received signal is y0(n)
rx0y0=xcorr(x0,y0);       // crosscorrelation between x0(n) and y0(n)
rx1y0=xcorr(x1,y0);       // crosscorrelation between x1(n) and y0(n)

scf();
subplot(2,1,1);
bar(rx0y0,0.1,'red');
title('Correlation between x0 and y0','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,1,2);
bar(rx1y0,0.1,'green');
title('Correlation between x1 and y0','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");


// If received signal is y1(n)
rx0y1=xcorr(x0,y1);       // crosscorrelation between x0(n) and y1(n)
rx1y1=xcorr(x1,y1);       // crosscorrelation between x1(n) and y1(n)

scf();
subplot(2,1,1);
bar(rx0y1,0.1,'red');
title('Correlation between x0 and y1','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,1,2);
bar(rx1y1,0.1,'green');
title('Correlation between x1 and y1','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
